% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{visual_compare}
\alias{visual_compare}
\title{Visually compare two models}
\usage{
visual_compare(model1, model2, ratio = FALSE)
}
\arguments{
\item{model1}{a \code{predictive} object}

\item{model2}{a \code{predictive} object}

\item{ratio}{show ratio rather than comparison (default: FALSE)}
}
\value{
A \code{ggplot2} object
}
\description{
Visually compare two models
}
\examples{
# define two models
data_model <- likelihood(family = "normal", .5, 1)
h0_mod <- prior(family = "point", point = 0)
h1_mod <- prior(family = "normal", mean = 0, sd = 10)
m0 <- extract_predictions(data_model * h0_mod)
m1 <- extract_predictions(data_model * h1_mod)

# visually compare the model
visual_compare(m0, m1)
# plot the ratio of the two model predictions
visual_compare(m0, m1, ratio = TRUE)
}
