% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{integral}
\alias{integral}
\title{Compute integral}
\usage{
integral(obj)
}
\arguments{
\item{obj}{a \code{product} object}
}
\value{
A numeric of the marginal likelihood
}
\description{
Computes the definite integral of a \code{product} object over the range
of the parameter
}
\examples{
# define a likelihood
data_model <- likelihood(family = "normal", mean = 5.5, sd = 32.35)

# define a prior
prior_model <- prior(family = "normal", mean = 5.5, sd = 13.3)

# multiply the likelihood by the prior
model <- data_model * prior_model

# take the integral
integral(model)
}
