% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{blockBAGR}
\alias{blockBAGR}
\title{Block Gibbs sampler function.}
\usage{
blockBAGR(X, burnIn, iterations, s = 1, t = 1, verbose = TRUE)
}
\arguments{
\item{X}{Numeric data matrix, data is assumed to be Gaussian distributed.}

\item{burnIn}{An integer specifying the number of burn-in iterations.}

\item{iterations}{An integer specifying the length of the Markov chain after the burn-in iterations.}

\item{s}{A double specifying the value of the prior inverse gamma's shape parameter.}

\item{t}{A double specifying the value of the prior inverse gamma's scale parameter.}

\item{verbose}{A logical determining whether the progress of the MCMC sampler should be displayed.}
}
\value{
blockBAGR: List of precision matrices from the Markov chains.
}
\description{
A Bayesian adaptive graphical ridge-type data-augmented block Gibbs sampler for simulating the posterior distribution of the concentration matrix specifying a Gaussian graphical model.
}
\examples{
# Generate true covariance matrix:
p             <- 10
n             <- 50
SigTrue       <- pracma::Toeplitz(c(0.7^rep(1:p-1)))
CTrue         <- pracma::inv(SigTrue)
# Generate expected value vector:
mu            <- rep(0,p)
# Generate multivariate normal distribution:
set.seed(123)
X             <- MASS::mvrnorm(n,mu=mu,Sigma=SigTrue)
posterior     <- blockBAGR(X,iterations = 1000, burnIn = 500)
}
