% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_summary.censReg.R
\name{summary.censReg}
\alias{summary.censReg}
\title{Summarizing Linear Model Fits}
\usage{
\method{summary}{censReg}(object, correlation = FALSE, ...)
}
\arguments{
\item{object}{an object of class "censReg"---output from \code{censReg}.}

\item{correlation}{include the correlation matrix of the estimated
parameters?}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
An object of class "summary.censReg" containing the object, 
the pseudo R-squared, variance inflation factors, a table of diagnostic 
statistics, critical values for selected diagnostic statistics, 
an indication of which observations exceed any of the selected 
diagnostic statistics, and optionally the parameter correlation matrix.
}
\description{
Summarizes the output from a censored regression object: method 
for "censReg" object.
}
\note{
The pseudo R-squared is computed using the McKelvey-Zavoina (1975) method,
which tries to describe the proportion of variance explained by the fit and
tries to capture the square of the correlation between the fitted and
actual values. For uncensored data, it is equal to the usual R-squared 
for ordinary least squares.
}
\references{
McKelvey, R.D., and Zavoina, W., 1975, A statistical model for
the analysis of ordinal dependent variables: The Journal of Mathematical
Sociology, v. 4, no. 1, p. 103--120.
}
\keyword{internal}
\keyword{regression}
