% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smwrQW_x_summary.R
\name{summary.lcens}
\alias{summary.lcens}
\alias{summary.mcens}
\alias{summary.qw}
\title{Summarize Data}
\usage{
\method{summary}{lcens}(object, ...)

\method{summary}{mcens}(object, ...)

\method{summary}{qw}(object, details = FALSE, ...)
}
\arguments{
\item{object}{the object to summarize.}

\item{\dots}{further arguments passed to other methods.}

\item{details}{provide details on multiple entries?}
}
\value{
For \code{details} = \code{FALSE}, a named character vector describe
some characteristics of \code{object}. For \code{details} = \code{TRUE}, a
named list containing vectors with all unique values.
}
\description{
Provide a summary of censored or water-quality data.
}
\note{
This function is used when \code{summary} is called on a data frame.
Setting \code{details} to \code{TRUE} can be useful for individual columns in
a data frame.
}
\examples{

\dontrun{
# Summrize these data
summary(importNWISqw("05330000", "00608"))
}

}
\keyword{internal}
\keyword{misc}
