% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSurvDF.R
\name{makeSurvDF}
\alias{makeSurvDF}
\title{Convert dataframe to include survival (Surv) objects}
\usage{
makeSurvDF(df, suf_lo = "_lo", suf_hi = "_hi")
}
\arguments{
\item{df}{name of data frame}

\item{suf_lo}{Column name suffix for "lo" values.  Default = "_lo"}

\item{suf_hi}{Column name suffix for "hi" values.  Default = "_hi"}
}
\value{
dataframe with Surv fields
}
\description{
Within a dataframe, paired numeric fields that use a "_lo" and
  "_hi" suffix naming convention (e.g., "conc_lo" "conc_hi") are combined
  into a single Surv object (e.g., "conc") using the "interval2" option
  provided by through the \code{survival::Surv(conc_lo, conc_hi, type =
  "interval2")} syntax.
}
\details{
Converting fields to Surv objects works with field pairs that have a "_lo" 
and "_hi" suffix naming convention. The numeric value for "_hi" must be greater than 
or equal to the "_lo" value. Source data that violate this requirement are 
set to NA with a summary report outputted to the console.

The user can specify their own values for the lo/hi suffixes or use the defaults.
}
\examples{
df <- dataCensored[1:20,]
colnames(df)
df1 <- unSurvDF(df)
colnames(df1)
# Default values
df2 <- makeSurvDF(df1)
colnames(df2)
# User values
df3 <- unSurvDF(df, "_LOW", "_HIGH")
colnames(df3)
df4 <- makeSurvDF(df3, "_LOW", "_HIGH")
colnames(df4)

}
\seealso{
\code{\link{unSurv}},  \code{\link{unSurvDF}},  \code{\link{impute}},  \code{\link{imputeDF}},  \code{\link{saveDF}},
}
