% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vars.R
\name{get_vars}
\alias{get_vars}
\title{Get formula variables}
\usage{
get_vars(formula, data = NULL, intersection = TRUE)
}
\arguments{
\item{formula}{a formula.}

\item{data}{data.frame or matrix. If not \code{NULL}, formulas with a dot \code{.} 
are permitted.}

\item{intersection}{logical. If \code{TRUE} and \code{data} is not \code{NULL}, the intersection 
between variables found in the formula and \code{data} column names is 
returned.}
}
\value{
a character vector, the variables found.
}
\description{
The function \code{get_vars} extracts variable names from a formula.
}
\examples{
get_vars(y ~ x1 + x2 - x1)
get_vars(y ~ . - x1, data = data.frame(y = 1, x1 = 2, x2 = 3))
get_vars(y + z ~ x1 + x2 - x1 | x3)
get_vars(y ~ x1 + I(log(x2)))
get_vars(y ~ x1*x2)
get_vars(y ~ x1:x2)
get_vars(~ x1 + x2)

}
\seealso{
\code{\link{all.vars}}, 
\code{\link[formula.tools]{get.vars}}
}
