% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Optimizer.R
\name{Optimizer}
\alias{Optimizer}
\title{Optimizer}
\description{
Abstract \code{Optimizer} class that implements the base functionality each
\code{Optimizer} subclass must provide. A \code{Optimizer} object describes the
optimization strategy.

A \code{Optimizer} object must write its result to the \verb{$assign_result()} method
of the \link{OptimInstance} at the end in order to store the best point  and its
estimated performance vector.
}
\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet}).}

\item{\code{param_classes}}{(\code{character()}).}

\item{\code{properties}}{(\code{character()}).}

\item{\code{packages}}{(\code{character()}).}

\item{\code{man}}{(\code{character()}).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Optimizer$new()}}
\item \href{#method-format}{\code{Optimizer$format()}}
\item \href{#method-print}{\code{Optimizer$print()}}
\item \href{#method-help}{\code{Optimizer$help()}}
\item \href{#method-optimize}{\code{Optimizer$optimize()}}
\item \href{#method-clone}{\code{Optimizer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Optimizer$new(
  param_set,
  param_classes,
  properties,
  packages = character(),
  man = NA_character_
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet}).}

\item{\code{param_classes}}{(\code{character()}).}

\item{\code{properties}}{(\code{character()}).}

\item{\code{packages}}{(\code{character()}).}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
Helper for print outputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Optimizer$format()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Optimizer$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\code{character()}).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-help"></a>}}
\if{latex}{\out{\hypertarget{method-help}{}}}
\subsection{Method \code{help()}}{
Opens the corresponding help page referenced by field \verb{$man}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Optimizer$help()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-optimize}{}}}
\subsection{Method \code{optimize()}}{
Performs the optimization and writes optimization result into
\link{OptimInstance}. The optimization result is returned but the complete
optimization path is stored in \link{Archive} of \link{OptimInstance}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Optimizer$optimize(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{OptimInstance}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[data.table:data.table]{data.table::data.table}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Optimizer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
