% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical_Inference.r
\name{sufficientStatistics_Weighted.CatDirichlet}
\alias{sufficientStatistics_Weighted.CatDirichlet}
\title{Weighted sufficient statistics of a "CatDirichlet" object}
\usage{
\method{sufficientStatistics_Weighted}{CatDirichlet}(obj, x, w, foreach = FALSE, ...)
}
\arguments{
\item{obj}{A "CatDirichlet" object.}

\item{x}{numeric,integer or character, samples of the Categorical distribution.}

\item{w}{numeric, sample weights.}

\item{foreach}{logical, specifying whether to return the sufficient staistics for each observation. Default FALSE.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
An object of class "ssCat", the sufficient statistics of a set of categorical samples. Or an object of the same class as x if foreach=TRUE.
}
\description{
For following Categorical-Dirichlet model structure: \cr
     pi|alpha ~ Dir(alpha) \cr
     x|pi ~ Categorical(pi) \cr
the sufficient statistics of a set of samples x and weights w are: \cr
  the effective counts (in this case the sum of the weight w) of each uniqueLabel in x \cr
Unique values of x must be in obj$gamma$uniqueLabels, where "obj" is a "CatDirichlet" object, see examples below.
}
\examples{
obj <- CatDirichlet(gamma=list(alpha=runif(26,1,2),uniqueLabels = letters))
x <- sample(letters,size = 20,replace = TRUE)
w <- runif(20)
sufficientStatistics(obj=obj,x=x)       #return the counts of each unique label
sufficientStatistics_Weighted(obj=obj,x=x,w=w) #return the weighted counts of each unique lable
}
\references{
Murphy, Kevin P. Machine learning: a probabilistic perspective. MIT press, 2012.
}
\seealso{
@seealso \code{\link{sufficientStatistics.CatDirichlet}} \code{\link{CatDirichlet}}
}
