% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical_Inference.r
\name{MAP.CatDirichlet}
\alias{MAP.CatDirichlet}
\title{MAP estimate of a "CatDirichlet" object}
\usage{
\method{MAP}{CatDirichlet}(obj, ...)
}
\arguments{
\item{obj}{A "CatDirichlet" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector, the MAP estimate of "pi".
}
\description{
Generate the MAP estimate of "pi" in following Categorical-Dirichlet structure: \cr
     pi|alpha ~ Dirichlet(alpha) \cr
     x|pi ~ Categorical(pi) \cr
the model structure and prior parameters are stored in a "CatDirichlet" object. \cr
MAP is pi_MAP = argmax p(pi|alpha,x).
}
\examples{
obj <- CatDirichlet(gamma=list(alpha=rep(1,26),uniqueLabels = letters))
x <- sample(letters,size = 20,replace = TRUE)
w <- runif(20)
posterior(obj=obj,ss=x,w=w)
MAP(obj)
}
\references{
Murphy, Kevin P. Machine learning: a probabilistic perspective. MIT press, 2012.
}
\seealso{
\code{\link{CatDirichlet}}
}
