% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{posterior.CatHDP}
\alias{posterior.CatHDP}
\title{Update a "CatHDP" object with sample sufficient statistics}
\usage{
\method{posterior}{CatHDP}(obj, ss1, ss2, j, w = NULL, ...)
}
\arguments{
\item{obj}{A "CatHDP" object.}

\item{ss1}{Sufficient statistics of k. In CatHDP case the sufficient statistic of sample k is k itself(if k is a integer vector with all positive values).}

\item{ss2}{Sufficient statistics of z. In CatHDP case the sufficient statistic of sample z is z itself(if z is a integer vector with all positive values).}

\item{j}{integer, group label.}

\item{w}{Sample weights, default NULL.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the model stored in "obj" will be updated based on "ss1" and "ss2".
}
\description{
For the model structure: \cr
     G_j|gamma ~ DP(gamma,U), j = 1:J \cr
     pi_j|G_j,alpha ~ DP(alpha,G_j) \cr
     z|pi_j ~ Categorical(pi_j) \cr
     k|z,G_j ~ Categorical(G_j), if z is a sample from the base measure G \cr
where DP(gamma,U) is a Dirichlet Process on integers, gamma is the concentration parameter of the Dirichlet Process. DP(gamma,G_j) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_j. \cr
In the case of CatHDP, z and k can only be positive integers. \cr
Update the prior knowledge by adding the information of newly observed samples z and k. The model structure and prior parameters are stored in a "CatHDP" object, the prior parameters in this object will be updated after running this function.
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{CatHDP}},\code{\link{posteriorDiscard.CatHDP}}
}
