% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{rPosteriorPredictive.CatHDP}
\alias{rPosteriorPredictive.CatHDP}
\title{Posterior predictive random generation of a "CatHDP" object}
\usage{
\method{rPosteriorPredictive}{CatHDP}(obj, n = 1L, j, ...)
}
\arguments{
\item{obj}{A "CatHDP" object.}

\item{n}{integer, number of samples.}

\item{j}{integer, group label.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
integer, the categorical samples.
}
\description{
Generate random samples from the posterior predictive distribution of the following structure: \cr
     G_j|gamma ~ DP(gamma,U), j = 1:J \cr
     pi_j|G_j,alpha ~ DP(alpha,G_j) \cr
     z|pi_j ~ Categorical(pi_j) \cr
     k|z,G_j ~ Categorical(G_j), if z is a sample from the base measure G \cr
where DP(gamma,U) is a Dirichlet Process on integers, gamma is the concentration parameter of the Dirichlet Process. DP(gamma,G_j) is a Dirichlet Process on integers with concentration parameter alpha and base measure G_j. \cr
In the case of CatHDP, z and k can only be positive integers. \cr
The model structure and prior parameters are stored in a "CatHDP" object. \cr
Posterior predictive is a distribution of z,k|alpha,gamm,U,G_j.
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
@seealso \code{\link{CatHDP}}, \code{\link{dPosteriorPredictive.CatHDP}}
}
