% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{dPosterior.LinearGaussianGaussian}
\alias{dPosterior.LinearGaussianGaussian}
\title{Posterior density function of a "LinearGaussianGaussian" object}
\usage{
\method{dPosterior}{LinearGaussianGaussian}(obj, z, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "LinearGaussianGaussian" object.}

\item{z}{matrix, or the ones that can be converted to matrix. Each row of z is an sample.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A numeric vector of the same length as nrow(z), the posterior density.
}
\description{
Generate the the density value of the posterior distribution of the following structure:
     \deqn{x ~ Gaussian(A z + b, Sigma)}
     \deqn{z ~ Gaussian(m,S)}
Where Sigma is known. A is a \eqn{dimx x dimz} matrix, x is a \eqn{dimx x 1} random vector, z is a \eqn{dimz x 1} random vector, b is a \eqn{dimm x 1} vector. Gaussian() is the Gaussian distribution. See \code{?dGaussian} for the definition of Gaussian distribution.\cr
The model structure and prior parameters are stored in a "LinearGaussianGaussian" object. \cr
Posterior density is the density function of Gaussian(z|m,S).
}
\examples{
obj <- LinearGaussianGaussian(gamma=list(Sigma=matrix(c(2,1,1,2),2,2),
                                         m=c(0.2,0.5,0.6),S=diag(3)))
z <- rGaussian(10,mu = runif(3),Sigma = diag(3))
dPosterior(obj = obj,z=z)
dPosterior(obj = obj,z=z,LOG=FALSE)
}
\seealso{
\code{\link{LinearGaussianGaussian}}, \code{\link{rPosterior.LinearGaussianGaussian}}
}
