% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dirichlet_Process.r
\name{posterior.CatDP}
\alias{posterior.CatDP}
\title{Update a "CatDP" object with sample sufficient statistics}
\usage{
\method{posterior}{CatDP}(obj, ss, w = NULL, ...)
}
\arguments{
\item{obj}{A "CatDP" object.}

\item{ss}{Sufficient statistics of x. In Categorical-DP case the sufficient statistic of sample x can either be an object of type "ssCatDP" generated by sufficientStatistics(), or x itself(if x is a integer vector with all positive values).}

\item{w}{Sample weights, default NULL.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the model stored in "obj" will be updated based on "ss".
}
\description{
For the model structure:
     \deqn{pi|alpha ~ DP(alpha,U)}
     \deqn{x|pi ~ Categorical(pi)}
where DP(alpha,U) is a Dirichlet Process on positive integers, alpha is the "concentration parameter" of the Dirichlet Process, U is the "base measure" of this Dirichlet process, it is an uniform distribution on all positive integers.Categorical() is the Categorical distribution. See \code{dCategorical} for the definition of the Categorical distribution. \cr
In the case of CatDP, x can only be positive integers. \cr
Update prior knowledge by adding the information of newly observed samples x. The model structure and prior parameters are stored in a "CatDP" object, the prior parameters in this object will be updated after running this function.
}
\examples{
## generate some integer samples
x <- sample(1L:10L,size = 40,replace = TRUE)
obj <- CatDP()
obj2 <- CatDP()
obj3 <- CatDP()
## update CatDP object with sufficient statistics
ss <- sufficientStatistics(obj=obj,x=x)
posterior(obj = obj,ss = ss)
## or, update with x itself
posterior(obj = obj2,ss = x)
## or, update with x itself, one by one
for(xx in x) posterior(obj = obj3,ss = xx)
## obj, obj2, obj3 should be the same:
obj
obj2
obj3
}
\references{
Teh, Yee W., et al. "Sharing clusters among related groups: Hierarchical Dirichlet processes." Advances in neural information processing systems. 2005.
}
\seealso{
\code{\link{CatDP}},\code{\link{posteriorDiscard.CatDP}},\code{\link{sufficientStatistics.CatDP}}
}
