% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma_Inference.r
\name{rInvWishart}
\alias{rInvWishart}
\title{Random generation for Inverse-Wishart distribution}
\usage{
rInvWishart(df, scale)
}
\arguments{
\item{df}{numeric, the degree of freedom.}

\item{scale}{matrix, a symmetric positive-definite matrix, the 'scale' parameter. The 'rate' parameter in Wishart is the 'scale' parameter in InvWishart.}
}
\value{
A symmetric positive-definite matrix.
}
\description{
Generate random samples from Inverse-Wishart distribution. For a random matrix x, the density function of Inverse-Wishart is defined as:
  \deqn{(2^{(df p)/2} Gamma_p(df/2) |scale|^{-df/2})^{-1} |x|^{(-df-p-1)/2} exp(-1/2 tr(x^{-1} scale))}
Where x is a pxp symmetric positive definite matrix, Gamma_p() is the multivariate Gamma function of dimension p.
}
\examples{
scale <- crossprod(matrix(rnorm(15),5,3)) # the prior scale
m <- matrix(0,3,3)
## get 1000 samples and calculate the sample mean
for(i in 1:1000){
    m <- m+rInvWishart(df=5,scale=scale)/1000
}
## m should roughly equal scale/(df-p-1), p is the dimension.
m
scale/(5-3-1)
}
\references{
Hoff, Peter D. A first course in Bayesian statistical methods. Vol. 580. New York: Springer, 2009.
}
