% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{dT}
\alias{dT}
\title{Density function for (multivariate) t distribution}
\usage{
dT(x, mu, Sigma = NULL, A = NULL, df = 1, LOG = TRUE)
}
\arguments{
\item{x}{matrix, when x is a numeric vector, it will be converted to a matrix with 1 column!}

\item{mu}{numeric, mean vector.}

\item{Sigma}{matrix, Sigma is proportional to the covariance matrix of x, one of Sigma and A should be non-NULL.}

\item{A}{matrix, the Cholesky decomposition of Sigma, an upper triangular matrix, one of Sigma and A should be non-NULL.}

\item{df}{numeric, degrees of freedom.}

\item{LOG}{logical, return log density of LOG=TRUE, default TRUE.}
}
\value{
A numeric vector, the probability densities.
}
\description{
Get the density of a set of samples from a t distribution. For a random vector x, the density function is defined as:
   \deqn{Gamma((df + p)/2) / (Gamma(df/2)df^{p/2} pi ^{p/2} |Sigma|^{1/2}) [1+1/df (x-df)^T Sigma^{-1} (x-df)]^{-(df +p)/2}}
Where p is the dimension of x.
}
\examples{
\donttest{
plot(
   dT(x=seq(-5,5,length.out = 1000),mu = 0,Sigma = 1,LOG = FALSE)
   ,type = "l"
)
}
}
\seealso{
\code{\link{rT}}
}
