% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcdc-web-services.R
\name{bcdc_query_geodata}
\alias{bcdc_query_geodata}
\title{Query data from the B.C. Web Feature Service}
\usage{
bcdc_query_geodata(record, crs = 3005)
}
\arguments{
\item{record}{either a \code{bcdc_record} object (from the result of \code{bcdc_get_record()}),
a character string denoting the name or ID of a resource (or the URL) or a BC Geographic
Warehouse (BCGW) name.

It is advised to use the permanent ID for a record or the BCGW name rather than the
human-readable name to guard against future name changes of the record.
If you use the human-readable name a warning will be issued once per
session. You can silence these warnings altogether by setting an option:
\code{options("silence_named_get_data_warning" = TRUE)} - which you can set
in your .Rprofile file so the option persists across sessions.}

\item{crs}{the epsg code for the coordinate reference system. Defaults to
\code{3005} (B.C. Albers). See https://epsg.io.}
}
\value{
A \code{bcdc_promise} object. This object includes all of the information
required to retrieve the requested data. In order to get the actual data as
an \code{sf} object, you need to run \code{\link[=collect]{collect()}} on the \code{bcdc_promise}.
}
\description{
Queries features from the B.C. Web Feature Service. See
\code{\link[=bcdc_tidy_resources]{bcdc_tidy_resources()}} - if a resource has a value of
\code{"wms"} in the \code{format} column it is available as a Web
Feature Service, and you can query and download it
using \code{bcdc_query_geodata()}. The response will be
paginated if the number of features is above the number
set by the \code{bcdata.single_download_limit} option.
Please see \code{\link[=bcdc_options]{bcdc_options()}} for defaults and more
information.
}
\details{
Note that this function doesn't actually return the data, but rather an
object of class \code{bcdc_promise}, which includes all of the information
required to retrieve the requested data. In order to get the actual data as
an \code{sf} object, you need to run \code{\link[=collect]{collect()}} on the \code{bcdc_promise}. This
allows further refining the call to \code{bcdc_query_geodata()} with \code{\link[=filter]{filter()}}
and/or \code{\link[=select]{select()}} statements before pulling down the actual data as an \code{sf}
object with \code{\link[=collect]{collect()}}. See examples.
}
\examples{

\donttest{
# Returns a bcdc_promise, which can be further refined using filter/select:
try(
  res <- bcdc_query_geodata("bc-airports", crs = 3857)
)

# To obtain the actual data as an sf object, collect() must be called:
try(
  res <- bcdc_query_geodata("bc-airports", crs = 3857) \%>\%
    filter(PHYSICAL_ADDRESS == 'Victoria, BC') \%>\%
    collect()
)

try(
  res <- bcdc_query_geodata("groundwater-wells") \%>\%
    filter(OBSERVATION_WELL_NUMBER == "108") \%>\%
    select(WELL_TAG_NUMBER, INTENDED_WATER_USE) \%>\%
    collect()
)

## A moderately large layer
try(
  res <- bcdc_query_geodata("bc-environmental-monitoring-locations")
)

try(
  res <- bcdc_query_geodata("bc-environmental-monitoring-locations") \%>\%
    filter(PERMIT_RELATIONSHIP == "DISCHARGE")
)


## A very large layer
try(
  res <- bcdc_query_geodata("terrestrial-protected-areas-representation-by-biogeoclimatic-unit")
)

## Using a BCGW name
try(
  res <- bcdc_query_geodata("WHSE_IMAGERY_AND_BASE_MAPS.GSR_AIRPORTS_SVW")
)
}
}
