% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threep3.R
\name{threep3}
\alias{threep3}
\title{Calculate all possible trial pathways for the standard 3+3 design,  together
with their probability of occurring}
\usage{
threep3(truep, threep3.start = 1, threep3.esc.only = FALSE,
  dose = NULL, quietly = FALSE)
}
\arguments{
\item{truep}{A vector of length \code{k} (the number of doses being
considered in the trial),  with values equal to the true probabilities of
toxicity at the dose levels.}

\item{threep3.start}{Starting dose level. Defaults to 1,  i.e. the lowest dose level}

\item{threep3.esc.only}{Whether to forbid de-escalation of doses. Defaults to \code{FALSE}}

\item{dose}{Optional vector of length \code{k} of actual doses for
presentation purposes}

\item{quietly}{Whether to report progress. Defaults to \code{quietly = FALSE}.}
}
\value{
\code{threep3} returns an object of class "threep3". The function
\code{\link{print}} (i.e. \code{\link{print.threep3}}) can be used to obtain
operating characteristics of the design used.

An object of class "threep3" is a list with the following components:
\item{prob}{A vector with the probabilities of each design occurring. As all
possible designs are calculated,  this vector sums to one} \item{ssize}{A
vector with the sample size of each design} \item{mtd}{A vector of dose
levels giving the recommended maximum tolerated dose (MTD) at the end of the
trial} \item{exp}{A vector of length \code{k} giving the average trial
experimentation proportions at each dose level} \item{dlt.no}{A vector with
the number of toxicities (DLTs) that occur in each trial} \item{truep}{The
true probabilities of toxicity at each dose level,  specified by the user}
\item{dose}{The actual doses as supplied in the function arguments}
\item{n.average}{The average number of patients dosed at each level}
\item{dlt.average}{The average number of DLTs experienced at each dose
level} \item{all.designs}{A matrix containing all possible 3+3 designs,  with
each row representing a different design. Columns labelled "d k" and "tox k"
represent the dose level and number of toxicities for the kth cohort, 
respectively.}
}
\description{
All possible pathways of a standard 3+3 design (may be escalation-only
(see Storer 1989, Reiner et al. 1999) or permit dose de-escalation (see Chang et al.
(2006))) are calculated and assigned a probability of 
occurring. This facilitates the calculation of operating 
characteristics, using \code{\link{print.threep3}} and
\code{\link{plot.threep3}}.
}
\details{
The first cohort of three patients are administered the starting dose
(usually the lowest dose). The trial then proceeds as follows: \itemize{
\item If none of the three patients experience a DLT,  then dose the next
three patients at the next highest dose level; \item If one of the three
patients last treated experiences a DLT,  then dose the next three patients
at the current dose level; \item If at least two patients in the first dose
level experience a DLT the trial is stopped for safety and no dose is
recommended; } Escalation / de-escalation rules to the next dose level for
subsequent cohorts proceed as follows: \itemize{ \item Escalate: If 0/3 or
at most 1/6 DLTs are observed in the current cohort AND the next highest
dose has not yet been tested; \item Stay at current dose level: If 1/3 DLTs
have been observed at this level. Dose a further three patients at the same
level; \item De-Escalate (if de-escalation permitted): If at least two out of three to six patients
experience DLTs at the current dose level AND fewer than six patients have
been dosed at the next lowest level }

If none of the rules above are satisfied then the trial stops. If the
current dose level has at most one DLT observed then this is claimed to be
the MTD,  otherwise the dose level below is deemed to be the MTD.

If dose-escalation extends to doses outside of that defined by \code{dose}, 
the MTD is determined to be the largest dose in \code{dose}.
}
\examples{

## What are the operating characteristics of a standard 3+3 design if we conside only the first 
## 12 doses of the dose-escalation cancer trial example as described in Neuenschwander et al 2008.
## Pre-defined doses
dose <- c(1, 2.5, 5, 10, 15, 20, 25, 30, 40, 50, 75, 100)
## Pre-specified probabilities of toxicity
p.tox0 <- c(0.010, 0.015, 0.020, 0.025, 0.030, 0.040, 0.050, 0.100, 0.170, 0.300, 0.400, 0.500)

\dontrun{
design.threep3 <- threep3(truep=p.tox0, threep3.start=1, threep3.esc.only=TRUE, dose=dose)
print(design.threep3)
plot(design.threep3)
}

}
\references{
Sweeting M.,  Mander A.,  Sabin T. \pkg{bcrm}: Bayesian Continual
Reassessment Method Designs for Phase I Dose-Finding Trials. \emph{Journal
of Statistical Software} (2013) 54: 1--26.
\url{http://www.jstatsoft.org/article/view/v054i13}

Chang A.,  Ganz P.,  Hayes D.,  Kinsella T.,  Pass H.,  Schiller J.,  Stone R., 
Strecher V. \emph{Oncology: An Evidence-Based Approach}. Springer (2006).

Storer B. Design and Analysis of Phase I Clinical Trials. \emph{Biometrics}
(1989) 45: 925--937.

Reiner E.,  Paoletti X.,  O'Quigley J. Operating characteristics of the
standard phase I clinical trial design. \emph{Computational Statistics &
Data Analysis} (1999) 30: 303--315.

Neuenschwander B.,  Branson M.,  Gsponer T. Critical aspects of the Bayesian
approach to phase I cancer trials. \emph{Statistics in Medicine} (2008) 27:
2420--2439.
}
\seealso{
\code{\link{threep3}}
}
\author{
Graham Wheeler \email{graham.wheeler@ucl.ac.uk} (University College London, UK) and

Michael Sweeting \email{michael.sweeting@leicester.ac.uk} (University of Leicester, 
UK)
}
