% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_quickmap.R
\name{bdc_quickmap}
\alias{bdc_quickmap}
\title{Create a map of points using ggplot2}
\usage{
bdc_quickmap(
  data,
  lat = "decimalLatitude",
  lon = "decimalLongitude",
  col_to_map = "red",
  size = 1
)
}
\arguments{
\item{data}{data.frame. Containing geographical coordinates. Coordinates must
be expressed in decimal degree and in WGS84.}

\item{lat}{character string. The column name with latitude. Coordinates must
be expressed in decimal degree and in WGS84. Default = "decimalLatitude".}

\item{lon}{character string. The column with longitude. Coordinates must be
expressed in decimal degree and in WGS84. Default = "decimalLongitude".}

\item{col_to_map}{character string. Defining the column or color used to map.
It can be a color name (e.g., "red") or the name of a column of data. Default
= "blue"}

\item{size}{numeric. The size of the points.}
}
\value{
A map of points created using ggplot2.
}
\description{
Creates a map of points using ggplot2 useful for inspecting the results of
tests implemented in the bdc package.
}
\details{
Only records with valid coordinates can be plotted. Records missing
or containing invalid coordinates are removed prior creating the map.
}
\examples{
\donttest{
decimalLatitude <- c(19.9358, -13.016667, -19.935800)
decimalLongitude <- c(-40.6003, -39.6, -40.60030)
.coordinates_out_country <- c(FALSE, TRUE, TRUE)
x <- data.frame(decimalLatitude, decimalLongitude, .coordinates_out_country)

bdc_quickmap(
  data = x,
  lat = "decimalLatitude",
  lon = "decimalLongitude",
  col_to_map = ".coordinates_out_country",
  size = 1
)
}
}
