## ----setup, include = FALSE----------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(bdl)
oldop <- options()
oldpar <- par()
options(tibble.print_min = 4L, tibble.print_max = 4L)

## ------------------------------------------------------------------------
get_levels()

## ------------------------------------------------------------------------
search_units(name = "wro")
search_units(name = "", level = 3)

## ------------------------------------------------------------------------
get_units(parentId = "000000000000", level = 5)

## ------------------------------------------------------------------------
search_subjects("lud")

## ------------------------------------------------------------------------
get_subjects()

## ------------------------------------------------------------------------
get_subjects(parentId = "K3")
get_subjects(parentId = "G7")

## ------------------------------------------------------------------------
get_variables("P2425")

## ------------------------------------------------------------------------
search_variables("samochod")

## ------------------------------------------------------------------------
search_variables("lud", subjectId = "P2425")

## ------------------------------------------------------------------------
get_data_by_unit(unitId = "023200000000", varId =  "3643")
get_data_by_unit(unitId = "023200000000", varId =  c("3643", "2137", "148190"))

## ------------------------------------------------------------------------
df <- get_data_by_unit(unitId = "023200000000", varId =  "3643", type = "label")

## ------------------------------------------------------------------------
get_data_by_variable("420", unitParentId = "011210000000")
get_data_by_variable("420", unitLevel = "3")

## ------------------------------------------------------------------------
df <- get_data_by_variable(varId = "3643", unitParentId = "010000000000")
summary(df)

## ----fig.height=5, fig.width=8-------------------------------------------
line_plot(data_type = "unit", unitId = "000000000000", varId = c("415","420"))

## ----fig.height=5, fig.width=8-------------------------------------------
pie_plot(data_type ="variable" ,"60559", "2006", unitLevel = "2")

## ----fig.height=5, fig.width=8-------------------------------------------
scatter_2var_plot(data_type ="variable" ,c("60559","415"), unitLevel = "2")

## ----fig.height=5, fig.width=8, eval=FALSE-------------------------------
#  generate_map(varId = "60559", year = "2017", unitLevel = 3)

## ------------------------------------------------------------------------
get_data_by_unit(unitId = c("023200000000", "020800000000"), varId =  c("3643", "2137", "148190"))

## ------------------------------------------------------------------------
get_data_by_variable(varId =c("3643","420"), unitParentId = "010000000000")

## ----include = FALSE-----------------------------------------------------
options(oldop)
par(oldpar)

