% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_by_unit_locality.R
\name{get_data_by_unit_locality}
\alias{get_data_by_unit_locality}
\title{Get data by unit locality Id from BDL API}
\usage{
get_data_by_unit_locality(unitId, varId, year = NULL, type = c("code",
  "label"), lang = c("pl", "en"), ...)
}
\arguments{
\item{unitId}{A 12 character NUTS unit locality id with 7 characters locality individual id, 
separated by dash or vector of  multiple unit id codes. If multiple unit codes are used, 
some columns are not available. Use \code{\link{search_unit_localities}} 
or \code{\link{get_unit_localities}} to find unit id code.}

\item{varId}{A vector of variable Id's.Use \code{\link{search_variables}} or
\code{\link{get_variables}} to find variable id code.}

\item{year}{A vector of years. If \code{NULL} (default) returns data for all available years.}

\item{type}{A type of variables returned, "code" (default), "label"}

\item{lang}{A language of returned data, "pl" (default), "en"}

\item{...}{Other arguments passed on to \code{\link[httr]{GET}}. For example
a proxy parameters, see details.}
}
\value{
A dataset as a tibble.
}
\description{
Retrieve data for a given unit localities from BDL with specified format.
}
\details{
Data to retrieve from
  \href{https://bdl.stat.gov.pl}{The
  BDL Web Services} can be filtered with arguments. To get JSON data from specified
  directory with custom filters use \code{\link{get_request}} directly.

  To use a proxy to connect, a \code{\link[httr]{use_proxy}} can be
  passed to \code{\link[httr]{GET}}. For example
  \code{get_request(id, filters,
  config = httr::use_proxy(url, port, username, password))}.
}
\examples{
 \donttest{
   get_data_by_unit_locality(unitId = "030210106062-0189782", varId =  "415", type = "label")
   
   # Multi variable download
   get_data_by_unit_locality(unitId = c("030210106062-0189782", "030210106062-0189753"), 
                             varId = "415")
}
}
\keyword{database}
\keyword{utilities}
