% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetAssigningPipe.R
\docType{class}
\name{TargetAssigningPipe}
\alias{TargetAssigningPipe}
\title{Class to get the target field of the Instance}
\usage{
TargetAssigningPipe
}
\description{
This class allows searching in the path the \strong{target} of the
\code{\link{Instance}}.
}
\section{Constructor}{

\preformatted{
TargetAssigningPipe$new(targets = list("ham","spam"),
                        targetsName = list("_ham_","_spam_"),
                        propertyName = "target",
                        alwaysBeforeDeps = list(),
                        notAfterDeps = list())
}
\itemize{
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{targets:}}{
(\emph{list}) name of the targets property.
}
\item{\strong{targetsName:}}{
(\emph{list}) the name of folders.
}
\item{\strong{propertyName:}}{
(\emph{character}) name of the property associated with the Pipe.
}
\item{\strong{alwaysBeforeDeps:}}{
(\emph{list}) the dependences alwaysBefore (Pipes that must be executed before this
one).
}
\item{\strong{notAfterDeps:}}{
(\emph{list}) the dependences notAfter (Pipes that cannot be executed after this one).
}
}
}
}
}

\section{Details}{

The targets that are searched can be controlled through the
constructor of the class where \emph{targetsName} will be the string that is
searched within the path and targets has the values that the property can
take.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\section{Methods}{

\itemize{
\item{\bold{pipe:}}{
preprocesses the \code{\link{Instance}} to obtain the target.
\itemize{
\item{\emph{Usage:}}{
\code{pipe(instance)}
}
\item{\emph{Value:}}{
The \code{\link{Instance}} with the modifications that have occurred in the Pipe.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{instance:}}{
(\emph{Instance}) \code{\link{Instance}} to preproccess.
}
}
}
}
}

\item{\bold{getTarget}}{
gets the target from a path.
\itemize{
\item{\emph{Usage:}}{

\code{getTarget(path)}
}
\item{\emph{Value:}}{
the target of the path.
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{path:}}{
(\emph{character}) path to analize.
}
}
}
}
}

\item{\bold{checkTarget:}}{
checks if the target is in the path.
\itemize{
\item{\emph{Usage:}}{
\code{checkTarget(target, path)}
}
\item{\emph{Value:}}{
if the target is found, returns target, else returns "".
}
\item{\emph{Arguments:}}{
\itemize{
\item{\strong{target:}}{
(\emph{character}) target to find in the path.
}
\item{\strong{path:}}{
(\emph{character}) path to analize.
}
}
}
}
}

\item{\bold{getTargets:}}{
gets of targets.
\itemize{
\item{\emph{Usage:}}{
\code{getTargets()}
}
\item{\emph{Value:}}{
value of targets.
}
}
}
}
}

\section{Private fields}{

\itemize{
\item{\bold{targets:}}{
 (\emph{list}) name of the targets property.
}
}
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindHashtagPipe}},
         \code{\link{FindUrlPipe}}, \code{\link{FindUserNamePipe}},
         \code{\link{GuessDatePipe}}, \code{\link{GuessLanguagePipe}},
         \code{\link{Instance}}, \code{\link{InterjectionPipe}},
         \code{\link{MeasureLengthPipe}}, \code{\link{GenericPipe}},
         \code{\link{ResourceHandler}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TeeCSVPipe}}, \code{\link{ToLowerCasePipe}}
}
