% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrca_prior_to_xml_operators.R
\name{mrca_prior_to_xml_operators}
\alias{mrca_prior_to_xml_operators}
\title{Creates the XML of an MRCA prior,
  as used in the \code{operators} section}
\usage{
mrca_prior_to_xml_operators(mrca_prior, fixed_crown_age = FALSE,
  has_non_strict_clock_model = FALSE, is_first = TRUE)
}
\arguments{
\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{fixed_crown_age}{determines if the phylogeny's crown age is
fixed. If FALSE, crown age is estimated by BEAST2. If TRUE,
the crown age is fixed to the crown age
of the initial phylogeny.}

\item{has_non_strict_clock_model}{boolean to indicate that the is
already at least one non-strict (i.e. relaxed log-normal) clock model}

\item{is_first}{is this the first MRCA prior?}
}
\value{
the mrca prior as XML text
}
\description{
Creates the XML of an MRCA prior,
  as used in the \code{operators} section
}
\author{
Richel J.C. Bilderbeek
}
