% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_alignment_id.R
\name{get_alignment_id}
\alias{get_alignment_id}
\title{Conclude the ID from a FASTA filename.}
\usage{
get_alignment_id(fasta_filename, capitalize_first_char_id = FALSE)
}
\arguments{
\item{fasta_filename}{a FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{capitalize_first_char_id}{if TRUE, the first character will
be capitalized}
}
\value{
an alignment's ID
}
\description{
This is done in the same way as BEAST2 will do so.
}
\examples{
  # Path need not exist, use UNIX path as example
  created <- get_alignment_id("/home/homer/anthus_aco_sub.fas")
  expected <- "anthus_aco_sub"
  testit::assert(created == expected)
}
\author{
Richèl J.C. Bilderbeek
}
