% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_distr.R
\name{is_exp_distr}
\alias{is_exp_distr}
\title{Determine if the object is a valid
exponential distribution
as created by \code{\link{create_exp_distr}}}
\usage{
is_exp_distr(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid
exponential distribution}
}
\value{
TRUE if x is a valid exponential distribution,
  FALSE otherwise
}
\description{
Determine if the object is a valid
exponential distribution
as created by \code{\link{create_exp_distr}}
}
\examples{
library(testthat)

expect_true(is_exp_distr(create_exp_distr()))
expect_false(is_exp_distr(create_gamma_distr()))
expect_false(is_exp_distr(NA))
expect_false(is_exp_distr(NULL))
expect_false(is_exp_distr("nonsense"))
}
\seealso{
use \code{\link{is_distr}} to see if x is any
  distribution
}
\author{
Richèl J.C. Bilderbeek
}
