% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_distr.R
\name{is_poisson_distr}
\alias{is_poisson_distr}
\title{Determine if the object is a valid
Poisson distribution
as created by \code{\link{create_poisson_distr}}}
\usage{
is_poisson_distr(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid
Poisson distribution}
}
\value{
TRUE if x is a valid Poisson distribution,
  FALSE otherwise
}
\description{
Determine if the object is a valid
Poisson distribution
as created by \code{\link{create_poisson_distr}}
}
\examples{
library(testthat)

expect_true(is_poisson_distr(create_poisson_distr()))

expect_false(is_poisson_distr(create_uniform_distr()))
expect_false(is_distr(NA))
expect_false(is_distr(NULL))
expect_false(is_distr("nonsense"))
}
\seealso{
use \code{\link{is_distr}} to see if x is any
  distribution
}
\author{
Richèl J.C. Bilderbeek
}
