% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_param.R
\name{create_rate_ct_param}
\alias{create_rate_ct_param}
\alias{create_param_rate_ct}
\title{Create a parameter called 'rate CT'}
\usage{
create_rate_ct_param(id = NA, value = "1.0", lower = "0.0")
}
\arguments{
\item{id}{the parameter's ID}

\item{value}{value of the parameter}

\item{lower}{lowest possible value of the parameter. If the parameter
is estimated, \code{lower} must be less than \code{value}}
}
\value{
a parameter called 'rate CT'
}
\description{
Create a parameter called 'rate CT'
}
\examples{
  # Create parameter
  rate_ct_param <- create_rate_ct_param(value = 1)

  # Use the parameter to create a BEAST2 input file
  beast2_input_file <- tempfile(fileext = ".xml")
  create_beast2_input_file(
    input_filename = get_fasta_filename(),
    beast2_input_file,
    site_model = create_gtr_site_model(
      rate_ct_param = rate_ct_param
    )
  )
  testit::assert(file.exists(beast2_input_file))
}
\seealso{
the function \code{\link{create_param}} contains a list
  of all parameters that can be created
}
\author{
Richèl J.C. Bilderbeek
}
