% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tree_prior.R
\name{create_bd_tree_prior}
\alias{create_bd_tree_prior}
\alias{create_tree_prior_bd}
\title{Create a Birth-Death tree prior}
\usage{
create_bd_tree_prior(
  id = NA,
  birth_rate_distr = create_uniform_distr(),
  death_rate_distr = create_uniform_distr()
)
}
\arguments{
\item{id}{the ID of the alignment}

\item{birth_rate_distr}{the birth rate distribution,
as created by a \code{\link{create_distr}} function}

\item{death_rate_distr}{the death rate distribution,
as created by a \code{\link{create_distr}} function}
}
\value{
a Birth-Death tree_prior
}
\description{
Create a Birth-Death tree prior
}
\examples{
bd_tree_prior <- create_bd_tree_prior()

beast2_input_file <- get_beautier_tempfilename()
create_beast2_input_file(
  input_filename = get_fasta_filename(),
  beast2_input_file,
  tree_prior = bd_tree_prior
)
file.remove(beast2_input_file)

bd_tree_prior_exp <- create_bd_tree_prior(
  birth_rate_distr = create_exp_distr()
)

beast2_input_file <- get_beautier_tempfilename()
create_beast2_input_file(
  input_filename = get_fasta_filename(),
  beast2_input_file,
  tree_prior = bd_tree_prior_exp
)
file.remove(beast2_input_file)
}
\seealso{
An alignment ID can be extracted from
  its FASTA filename using \code{\link{get_alignment_id}}
}
\author{
Richèl J.C. Bilderbeek
}
