% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_tip_dating.R
\name{has_tip_dating}
\alias{has_tip_dating}
\title{Determine if the \code{inference_model} uses tip dating.}
\usage{
has_tip_dating(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
TRUE if the \code{inference_model} uses tip dating,
FALSE otherwise
}
\description{
Determine if the \code{inference_model} uses tip dating
}
\examples{
check_empty_beautier_folder()

# Yes, has tip dating
has_strict_clock_model(
  create_inference_model(
    tipdates_filename = get_beautier_path("test_output_0_tipdates.tsv")
  )
)

# No tip dating
has_strict_clock_model(
  create_inference_model()
)

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
