% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_mrca_align_ids_in_fasta.R
\name{are_mrca_align_ids_in_fasta}
\alias{are_mrca_align_ids_in_fasta}
\title{Determine if the MRCA priors' alignment IDs are present in the FASTA files}
\usage{
are_mrca_align_ids_in_fasta(mrca_prior, fasta_filename)
}
\arguments{
\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{fasta_filename}{a FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.
Note that BEAST2 also supports missing data,
by using a dash (\code{-}) or question mark (\code{?})
as a sequence.}
}
\value{
TRUE if all the MRCA priors' alignment IDs
  are present in the FASTA files.
  Returns FALSE otherwise
}
\description{
Determine if the MRCA priors' alignment IDs are present in the FASTA files
}
\author{
Richèl J.C. Bilderbeek
}
