% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abcd.R
\name{abcd}
\alias{abcd}
\alias{print.abcdiagram}
\title{Acyclic Behavior Change Diagram}
\usage{
abcd(specs, specCols = c("bcps", "cnds", "apps", "sdts", "dets", "pobs",
  "behs"), omitColOrder = c("cnds", "behs", "bcps", "apps"),
  localBackup = NULL, title = "Acyclic Behavior Change Diagram\\n\\n",
  outputFile = NULL, outputWidth = 3000, outputHeight = 1500,
  includeColNames = TRUE, maxLabelLength = 30, silent = FALSE,
  returnGraphOnly = FALSE, returnSvgOnly = FALSE,
  regExReplacements = list(c("\\\\\\"", "`"), c("\\\\'", "`"), c("\\\\\\\\", "/")))

\method{print}{abcdiagram}(x, width = x$input$width,
  height = x$input$height,
  title = DiagrammeR::get_graph_name(x$output$graph), ...)
}
\arguments{
\item{specs}{The specifications: either a google sheets URL,
the path to a local file, a character vector with both,
or a matrix or data frame}

\item{specCols}{The order of the columns. This character vector
specified the order of the elements of an ABCD. In the default
order, from left to right, these are (see below for definitions
and more details):
\itemize{
\item \code{bcps} = \strong{Behavior Change Principles (BCPs)};
\item \code{cnds} = \strong{Conditions for effectiveness};
\item \code{apps} = \strong{Applications};
\item \code{sdts} = \strong{Sub-determinants};
\item \code{dets} = \strong{Determinants};
\item \code{pobs} = \strong{Performance Objectives};
\item \code{behs} = \strong{Behaviors};
}}

\item{omitColOrder}{If not all seven columns are available in the
specifications, this character vector specifies which columns
are assumed to be omitted.}

\item{localBackup}{Whether to write the specifications
to a local backup}

\item{title}{The title of the diagram}

\item{outputFile}{If specified, the ABCD is written to
this file using \link[DiagrammeR:export_graph]{DiagrammeR::export_graph}.}

\item{outputWidth, outputHeight}{If an \code{outputFile} is
specified, these determine its width and height (in pixels)}

\item{includeColNames}{Whether to include the column names
as titles/legend for the entities in each 'column'
of the ABCD.}

\item{maxLabelLength}{At which width to word wrap the
labels.}

\item{silent}{Whether to suppress (\code{TRUE}) or show
(\code{FALSE}) more detailed information.}

\item{returnGraphOnly, returnSvgOnly}{Whether to return the full results
object or only either the \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} graph or a one-value
character vector containing a Scalable Vector Graphic as produced by
\code{\link[DiagrammeRsvg:export_svg]{DiagrammeRsvg::export_svg()}}.}

\item{regExReplacements}{A list of pairs of regular
expressions that will be applied to the specifications
before generating the ABCD. This can be used to sanitize
problematic characters (e.g. ', " and ).}

\item{x}{The ABCD object to print (as generated by a call to \code{abcd}).}

\item{width, height}{Width and height to use when printing the ABCD.}

\item{\dots}{Any additional arguments are passed on to
\code{\link[DiagrammeR:render_graph]{DiagrammeR::render_graph()}}.}
}
\value{
A list consisting of an \code{input}, \code{intermediate}, and
\code{output} list, where the ABCD is stored in the \code{output} list
as a \link[DiagrammeR:DiagrammeR]{DiagrammeR::DiagrammeR} called \code{graph}.
}
\description{
This function generates an acyclic behavior change diagram (ABCD)
from a specification in a google sheet or .csv file. An ABCD is
a logic model that illustrates the assumptions underlying a
behavior change intervention. Specifically, the ABCD shows the
assumed causal and structural assumptions, thereby showing what is
assumed to cause what (e.g. which elements of the intervention are
assumed to influence which aspects of the target population's
psychology?) and what is assumed to consist of what (e.g. which
determinants are assumed to contain which specific aspects of the
target population's psychology?).
}
\details{
Specifically, a full ABCD is a model that shows the following
elements:
\itemize{
\item \strong{Behavior Change Principles (BCPs)}: The specific
psychological principles engaged to influence the relevant
sub-determinants, usually selected using the determinants
to which the sub-determinants 'belong'. These are also
known as methods of behavior change in the Intervention
Mapping framework, or behavior change techniques, BCTs,
in the Behavior Change Wheel approach. For a list of 99
BCPs, see Kok et al. (2016).
\item \strong{Conditions for effectiveness}: The conditions
that need to be met for a Behavior Change Principle (BCP) to
be effective. These conditions depend on the specific
underlying Evolutionary Learning Processes (ELPs) that the
BCP engages (Crutzen & Peters, 2018). If the conditions for
effectiveness (called \emph{parameters} for effectiveness in the
Intervention Mapping framework) are not met, the method will
likely not be effective, or at least, not achieve its
maximum effectiveness.
\item \strong{Applications}: Since BCP's describe aspects of
human psychology in general, they are necessarily formulated
on a generic level. Therefore, using them in an intervention
requires translating them to the specific target population,
culture, available means, and context. The result of this
translation is the application of the BCP. Multiple BCPs can
be combined into one application; and one BCP can be applied in
multiple applications (see Kok, 2014).
\item \strong{Sub-determinants}: Behavior change interventions
engage specific aspects of the human psychology (ideally, they
specifically, target those aspects found most important in
predicting the target behavior, as can be established with
\code{\link[behaviorchange]{CIBER}} plots. These aspects are
called sub-determinants (the Intervention Mapping framework
references \emph{Change Objectives}, which are sub-determinants
formulated according to specific guidelines). In some
theoretical traditions, sub-determinants are called \emph{beliefs}.
\item \strong{Determinants}: The overarching psychological constructs that
are defined as clusters of specific aspects of the human
psychology that explain humans' behavior (and are targeted
by behavior change interventions). Psychological theories
contain specific definitions of such determinants, and make
statements about how they relate to each other and to human
behavior. There are also theories (and exists empirical
evidence) on how these determinants can be changed (i.e. BCPs),
so althought the sub-determinants are what is targeted in an
intervention, the selection of feasible BCPs requires knowing
to which determinants those sub-determinants belong.
\item \strong{Performance objectives}: The specific sub-behaviors that often
underlie (or make up) the ultimate target behavior. These are
distinguished from the overarching target behavior because
the relevant determinants of these sub-behaviors can be
different: for example, the reasons why people do or do not
\emph{buy} condoms can be very different from the reasons why they
do or do not \emph{carry} condoms or why they do or do not
\emph{negotiate} condom use with a sexual partner.
\item \strong{Behavior}: The ultimate target behavior of the intervention,
usually an umbrella that implicitly contains multiple
performance objectives.
}

For details, see Peters et al. (2019).
}
\examples{
### Using 'print' to prevent pkgdown() from choking
### Partial acyclic behavior change diagram of only
### one performance objective (sub-behavior)
### (using the 'abcd_specs_single_po_without_conditions'
###  dataset in this package)
print(behaviorchange::abcd(behaviorchange::abcd_specs_single_po_without_conditions));

### Acyclic behavior change diagram including multiple
### sub-behaviors (performance objectives)
### (using the 'abcd_specs_complete' dataset in this
###  package)
print(behaviorchange::abcd(behaviorchange::abcd_specs_complete));
}
\references{
Crutzen, R., & Peters, G.-J. Y. (2018). Evolutionary
learning processes as the foundation for behaviour change.
\emph{Health Psychology Review,} 12(1), 43–57.
https://doi.org/10.1080/17437199.2017.1362569

Kok, G. (2014). A practical guide to effective behavior
change: How to apply theory- and evidence-based behavior
change methods in an intervention. \emph{European Health Psychologist},
16(5), 156–170. https://doi.org/10.31234/osf.io/r78wh

Kok, G., Gottlieb, N. H., Peters, G.-J. Y., Mullen,
P. D., Parcel, G. S., Ruiter, R. A. C., … Bartholomew,
L. K. (2016). A taxonomy of behavior change methods:
an Intervention Mapping approach. \emph{Health Psychology
Review}, 10(3), 297–312.
https://doi.org/10.1080/17437199.2015.1077155

Peters, G.-J. Y., et al. (2019) The core of
behavior change: introducing the Acyclic Behavior Change
Diagram to report and analyze interventions.
}
\author{
Gjalt-Jorn Peters, \email{gjalt-jorn@a-bc.eu}, with
contributions from Matti Heino and Sander Eggers.
}
