% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_boltzmann.R
\name{get_boltzmann}
\alias{get_boltzmann}
\alias{get_boltzmann.default}
\alias{get_boltzmann.matrix}
\alias{get_boltzmann.array}
\alias{get_boltzmann.RasterLayer}
\alias{get_boltzmann.RasterStack}
\alias{get_boltzmann.RasterBrick}
\alias{get_boltzmann.stars}
\title{Boltzmann entropy of a landscape gradient}
\usage{
get_boltzmann(
  x,
  method = "aggregation",
  na_adjust = TRUE,
  base = "log10",
  relative = FALSE
)

\method{get_boltzmann}{default}(
  x,
  method = "aggregation",
  na_adjust = TRUE,
  base = "log10",
  relative = FALSE
)

\method{get_boltzmann}{matrix}(
  x,
  method = "aggregation",
  na_adjust = TRUE,
  base = "log10",
  relative = FALSE
)

\method{get_boltzmann}{array}(
  x,
  method = "aggregation",
  na_adjust = TRUE,
  base = "log10",
  relative = FALSE
)

\method{get_boltzmann}{RasterLayer}(
  x,
  method = "aggregation",
  na_adjust = TRUE,
  base = "log10",
  relative = FALSE
)

\method{get_boltzmann}{RasterStack}(
  x,
  method = "aggregation",
  na_adjust = TRUE,
  base = "log10",
  relative = FALSE
)

\method{get_boltzmann}{RasterBrick}(
  x,
  method = "aggregation",
  na_adjust = FALSE,
  base = "log10",
  relative = FALSE
)

\method{get_boltzmann}{stars}(
  x,
  method = "aggregation",
  na_adjust = TRUE,
  base = "log10",
  relative = FALSE
)
}
\arguments{
\item{x}{stars, RasterLayer, RasterStack, RasterBrick, matrix, or array.}

\item{method}{A method used. Either "hierarchy" for
the hierarchy-based method (Gao et al., 2017) or "aggregation" (default)
for the aggregation-based method (Gao et al., 2019).}

\item{na_adjust}{Should the output value be adjusted to the proportion of not missing cells? Either TRUE (default) or FALSE}

\item{base}{A logarithm base ("log", "log2" or "log10").}

\item{relative}{Should a relative or absolute entopy be calculated? TRUE or FALSE (default).}
}
\value{
a numeric vector
}
\description{
Calculates the Boltzmann entropy of a landscape gradient
}
\details{
The method for computing the Boltzmann entropy of a landscape
gradient works on integer values that are either positive or equals to zero.
This function automatically rounds values to the nearest integer value
(rounding halfway cases away from zero) and negative values are shifted to
positive values.
}
\examples{
new_c = c(56, 86, 98, 50, 45, 56, 96, 25,
          15, 55, 85, 69, 12, 52, 25, 56,
          32, 25, 68, 98, 58, 66, 56, 58)


lg = matrix(new_c, nrow = 3, ncol = 8, byrow = TRUE)
get_boltzmann(lg, relative = FALSE, method = "hierarchy", base = "log10")
get_boltzmann(lg, relative = TRUE, method = "hierarchy", base = "log2")
get_boltzmann(lg, relative = TRUE, method = "hierarchy", base = "log")

}
\references{
Gao, Peichao, Hong Zhang, and Zhilin Li. "A hierarchy-based
solution to calculate the configurational entropy of landscape gradients."
Landscape Ecology 32.6 (2017): 1133-1146.

Gao, Peichao, Hong Zhang, and Zhilin Li. "An efficient
analytical method for computing the Boltzmann entropy of a landscape
gradient." Transactions in GIS (2018).

Gao, Peichao and Zhilin Li. "Aggregation-based method
for computing absolute Boltzmann entropy of landscape gradient
with full thermodynamic consistency"
Landscape Ecology (2019)
}
