% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplot.R
\name{boxplot.benchmark}
\alias{boxplot.benchmark}
\title{Boxplot method for the \code{benchmark} timings}
\usage{
\method{boxplot}{benchmark}(x, units = "auto", log = TRUE, xlab, ylab,
  horizontal = FALSE, violin = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{benchmark}.}

\item{units}{Character. The units to be used in printing the timings.
The available units are nanoseconds (\code{"ns"}), microseconds
(\code{"us"}), milliseconds (\code{"ms"}), seconds (\code{"s"}).}

\item{log}{Logical. Should times be plotted on log scale?}

\item{xlab}{Character. X axis label.}

\item{ylab}{Character. Y axis label.}

\item{horizontal}{Logical. If set to \code{TRUE}, X and Y axes will be switched. Defaults to \code{FALSE}.}

\item{violin}{Logical. Use \code{\link[ggplot2:geom_violin]{ggplot2::geom_violin()}} instead \code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}} for the \code{ggplot} plots.}

\item{...}{Arguments passed on to \code{\link[=boxplot.default]{boxplot.default()}}.}
}
\description{
Displays measurement results as box plots, with R expressions on X axis and
execution time on Y axis.
}
\details{
If \code{ggplot2} package is available, it will be used. In order to switch to default
\code{boxplot} from the \code{graphics} package set option \code{benchr.use_ggplot}
to \code{FALSE}: \code{options(benchr.use_ggplot = FALSE)}.
}
\examples{
timings <- benchmark(
  rchisq(100, 0), rchisq(100, 1), rchisq(100, 2),
  rchisq(100, 3), rchisq(100, 5),
  times = 1000L
)
boxplot(timings)
}
\seealso{
\code{\link[=plot.benchmark]{plot.benchmark()}}
}
\author{
Artem Klevtsov \email{a.a.klevtsov@gmail.com}
}
