% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizePathCP.R
\name{normalizePathCP}
\alias{normalizePathCP}
\title{normalizePath Cross Platform}
\usage{
normalizePathCP(path, winslash = "/", mustWork = FALSE)
}
\arguments{
\item{path}{Character vector of file paths}

\item{winslash}{Path separator on Windows. 
DEFAULT: "/" (unlike \code{\link{normalizePath}})}

\item{mustWork}{Logical for \code{\link{normalizePath}}. DEFAULT: FALSE}
}
\value{
path character string(s)
}
\description{
\code{\link{normalizePath}} Cross Platform: Returns absolute
             path even for not (yet) existing files even on Linux. 
             On Windows, this is the default behaviour.
}
\examples{

normalizePath  ("doesnotexist.file", mustWork=FALSE) # on linux not full path
normalizePathCP("doesnotexist.file") # full path on all platforms

checknp <- function(a,b=a,d=getwd()) 
  {
  aa <- normalizePathCP(a)
  bb <- if(d=="") b else paste0(d,"/",b)
  if(aa != bb) stop("'", a, "' -> '", aa, "', should be '",bb, "'.")
  aa
  }

checknp("notexist.file")
checknp("../notexist.file", "notexist.file", dirname(getwd()))
checknp("notexistfolder/notexist.file")
#checknp("/home/berry/notexist.file", d="") # fails on windows
#checknp("S:/Dropbox/notexist.file",d="") # fails on linux

}
\seealso{
\code{\link{normalizePath}}, \code{\link{newFilename}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Nov 2017
}
\keyword{file}
