% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bes_g_cushman.R
\name{bes_g_cushman}
\alias{bes_g_cushman}
\title{Configurational entropy for surfaces}
\usage{
bes_g_cushman(x, nr_of_permutations = 1000, independent = FALSE)
}
\arguments{
\item{x}{SpatRaster, stars, RasterLayer, RasterStack, RasterBrick, matrix, or array containing one or more continuous rasters}

\item{nr_of_permutations}{Number of permutations performed on each input raster to calculate
possible distribution of "slope" values}

\item{independent}{Should an independent set of permutations be performed for each input raster?
\code{TRUE}/\code{FALSE}.
Use \code{FALSE} (default) when each of your input rasters has the same configuration.}
}
\value{
A tibble
}
\description{
Calculates Cushman's configurational entropy for surfaces (2021)
}
\examples{
\donttest{
  library(bespatial)
  library(terra)
  gradient = rast(system.file("raster/gradient.tif", package = "bespatial"),
                       lyrs = 1)
  ce2 = bes_g_cushman(gradient, 100)
  plot(gradient, main = round(ce2$value, 2))
  bes_g_cushman(gradient, 1000, independent = TRUE)
}
}
\references{
Cushman, S. A. (2021). Generalizing Boltzmann Configurational Entropy to Surfaces, Point Patterns and Landscape Mosaics. In Entropy (Vol. 23, Issue 12, p. 1616). MDPI AG. https://doi.org/10.3390/e23121616
}
