% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMC-methods.R
\name{confint.betamc}
\alias{confint.betamc}
\title{Confidence Intervals for Standardized Regression Slopes}
\usage{
\method{confint}{betamc}(object, parm = NULL, level = 0.95, ...)
}
\arguments{
\item{object}{Object of class \code{betamc}.}

\item{parm}{a specification of which parameters
are to be given confidence intervals,
either a vector of numbers or a vector of names.
If missing, all parameters are considered.}

\item{level}{the confidence level required.}

\item{...}{additional arguments.}
}
\value{
Returns a matrix of confidence intervals.
}
\description{
Confidence Intervals for Standardized Regression Slopes
}
\examples{
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
out <- BetaMC(object, R = 100)
# use a large R, for example, R = 20000 for actual research
confint(out, level = 0.95)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{methods}
