% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{afac}
\alias{afac}
\title{Ascending (rising) factorial.}
\usage{
afac(x, r, method = "product")
}
\arguments{
\item{x}{A value for which the ascending factorial is to be calculated.}

\item{r}{The power \code{x} is to be raised to.}

\item{method}{The method by which the descending factorials are to be calculated. Default is \code{"product"} which uses direct arithmetic. Alternative is \code{"gamma"} which calculates the descending factorial using the Gamma function. The alternative method might be faster but might fail because the Gamma function is not defined for negative integers (returning Inf).}
}
\value{
The ascending factorial of value \code{x} raised to the \code{r}'th power.
}
\description{
Calculate the ascending (or rising) factorial of a value \code{x} of order \code{r}.
}
\examples{
# To calculate the 4th ascending factorial for a value (e.g., 3.14):
afac(x = 3.14, r = 4)

# To calculate the 5th ascending factorial for values 3.14, 2.72, and 0.58:
afac(x = c(3.14, 2.72, 0.58), r = 5)
}
