% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{betabinomialmoments}
\alias{betabinomialmoments}
\title{Compute Moments of Beta-Binomial Probability Mass Functions.}
\usage{
betabinomialmoments(
  N,
  l,
  u,
  alpha,
  beta,
  types = c("raw", "central", "standardized"),
  orders = 4
)
}
\arguments{
\item{N}{Number of trials.}

\item{l}{The first (lower) location-parameter of the Beta distribution.}

\item{u}{The second (upper) location-parameter of the Beta distribution.}

\item{alpha}{The alpha (first) shape-parameter of the Beta distribution.}

\item{beta}{The beta (second) shape-parameter of the Beta-distribution.}

\item{types}{A character vector determining which moment-types are to be calculated. Permissible values are "raw", "central", and "standardized".}

\item{orders}{The number of moment-orders to be calculated for each of the moment-types.}
}
\value{
A list of moment types, each a list of moment orders.
}
\description{
Computes Raw, Central, or Standardized moment properties of defined Beta-Binomial probability mass functions.
}
\examples{
# Assume 100 observations of a discrete variable with probabilities of
# positive outcomes adhering to a four-parameter Beta distribution with
# location parameters l = 0.25 and u = .95, and shape parameters a = 5 and
# b = 3. To compute the first four raw, central, and standardized moments of
# this distrubution using betabinomialmoments():
betabinomialmoments(N = 100, l = .25, u = .95, alpha = 5, beta = 3,
types = c("raw", "central", "standardized"), orders = 4)
}
\references{
Hanson, B. A (1991). Method of Moments Estimates for the Four-Parameter Beta Compound Binomial Model and the Calculation of Classification Consistency Indexes. American College Testing Research Report Series.
}
