% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irf.R
\name{irf}
\alias{irf}
\title{Item Response Function}
\usage{
irf(a, d, t, from = -3, to = 3, by = 0.01, layout_matrix = 1,
  main_title = "Item Response Function", sub = "",
  option_names = NULL, line_types = NULL, color = "black",
  rug = FALSE, thetas = NULL, responses = NULL, sides = 1,
  rug_colors = "black")
}
\arguments{
\item{a}{A numeric vector of alpha parameters}

\item{d}{A numeric vector of delta parameters}

\item{t}{Either a list of numeric vectors for the tau parameters for each
option, or a numeric vector if the IRF for only one item is desired --
note the first element of each vector should be zero}

\item{from}{A numeric vector of length one,
the lowest theta value to estimate response probabilities for;
default is -3}

\item{to}{A numeric vector of length one,
the highest theta value to estimate response probabilities for;
default is 3}

\item{by}{A numeric vector of length one giving the spacing between
theta values; default is 0.01}

\item{layout_matrix}{An integer matrix dictating the layout of the plot;
the default is a one-column matrix with one element for each item}

\item{main_title}{A character vector giving the plots' main titles;
default is "Item Response Function".}

\item{sub}{An optional character vector of subtitles for the resulting plots,
to be pasted onto the main title (helpful for titling individual plots
when plotting multiple items' IRFs).}

\item{option_names}{An optional character vector giving names for the items'
options; if NULL, generic names (e.g. "Option 1", "Option 2", etc.)
are used}

\item{line_types}{An optional integer vector specifying lty for each option;
if not provided, the first option for each question will have lty = 1,
the second will have lty = 2, etc.}

\item{color}{A specification of the colors to draw lines in. Colors can be
specified by either a character vector of colors (either names that R
recognizes or hexidecimal specifications) or a function taking a single
argument for the number of colors to return. See
\code{\link{color_palettes}} for a list of color palettes provided
by \code{bggum}. The default is "black" (for all lines).}

\item{rug}{A logical vector of length one specifying whether to draw a
rug of theta estimates; the default is FALSE}

\item{thetas}{An optional vector of theta estimates for rug drawing;
if \code{rug = TRUE} and \code{thetas} is not provided,
an error will be thrown.}

\item{responses}{An optional matrix or vector (if the IRF for only one item
is desired) of responses; if \code{rug = TRUE} and \code{responses} is not
provided, an error will be thrown.
NOTE: The lowest response for each item should be 0, not 1.}

\item{sides}{A vector giving the side(s) to draw the rug on if
\code{rug = TRUE}; if the vector is of length > 1, the first option for
each item will be drawn on the side given by the first element of the
vector, the rug for the second option for each item will be drawn on the
side given by the second element of the vector, etc.}

\item{rug_colors}{A vector giving the color(s) to draw the rug in if
\code{rug = TRUE} or a function taking a single argument for the number of
colors to return. See \code{\link{color_palettes}} for a list of color
palettes provided by \code{bggum}. The default is "black" (for all rugs).}
}
\description{
Plots response functions given alpha, delta, and tau parameters.
}
\examples{
## We'll simulate data to use for these examples:
set.seed(123)
sim_data <- ggum_simulation(100, 10, 4)
## You can plot the IRF for one item:
irf(sim_data$alpha[1], sim_data$delta[1], sim_data$tau[[1]],
    option_names = 0:3)
## Or multiple items:
irf(sim_data$alpha[1:2], sim_data$delta[1:2], sim_data$tau[1:2],
    option_names = 0:3, sub = 1:2)
## You can plot it in color:
irf(sim_data$alpha[1], sim_data$delta[1], sim_data$tau[[1]],
    option_names = 0:3, color = tango)
## You can also plot a rug of the repsondents' theta estimates with the IRF
irf(sim_data$alpha[1], sim_data$delta[1], sim_data$tau[[1]],
    rug = TRUE, responses = sim_data$response_matrix[ , 1],
    thetas = sim_data$theta, option_names = 0:3)

}
