% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbgumbel.R
\name{rbgumbel}
\alias{rbgumbel}
\title{Bimodal Gumbel: Pseudo-Random Numbers Generator}
\usage{
rbgumbel(n, mu, sigma, delta)
}
\arguments{
\item{n}{Number of observations. If length(n) > 1, the length is taken to be the number required.}

\item{mu}{First location parameter.}

\item{sigma}{Scale parameter.}

\item{delta}{Second location parameter.}
}
\value{
A matrix nx1.
}
\description{
Bimodal Gumbel: Pseudo-Random Numbers Generator
}
\examples{
x <- rbgumbel(40000, mu = -2, sigma = 1, delta = -1)
hist(x, probability = TRUE)
curve(dbgumbel(x, mu = -2, sigma = 1, delta = -1), add = TRUE, col = 'blue')
lines(density(x), col = 'red')
}
