% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculatePCE.R
\name{calculatePCE}
\alias{calculatePCE}
\title{WWARN Parasite Clearance Estimator (PCE)}
\usage{
calculatePCE(data, detect.limit = 15, outlier.detect = TRUE, ...)
}
\arguments{
\item{data}{a data frame containing the profiles of patients.
This data frame must contain \code{id}, \code{time}, and \code{count} columns, 
in that order. The first column represents the IDs of patients. 
The second and third columns contain parasite measurements (per microliter) in different times.}

\item{detect.limit}{detection limit of the parasite density in blood}

\item{outlier.detect}{indicator of whether or not to use Flegg's outlier detection method}

\item{...}{additional parameters.}
}
\value{
All results are saved under a folder named "PceEstimates" under the current working directory.
\item{output}{Output data frame. If \code{outlier.detect = TRUE}, the cleaned data frame will be returned.}
}
\description{
This function is a wrapper function of the WWARN PCE method to calculate the parasite clearance rates of 
a given data set of patient profiles. The function returns the output data frame and it also saves more comprehensive 
outputs under a folder named "PceEstimates" under the current working directory.
}
\details{
This function gives users a way to calculate the parasite clearance rates by using the method in Flegg et al. (2011). 
Users can compare the results with that given by our method of Bayesian heierarchical model. The output is saved under 
a folder named "PceEstimates" under the current working directory. \code{data} should be a data frame in the form of the example data 
\code{pursat} provided in this package. \code{detect.limit} is the detection limit of the parasite density in blood. The default
value is set to be 15. \code{outlier.detect} is an indicator users can turn off if the dataset has already been cleaned. Otherwise,
it is always recommended to set \code{outlier.detect = TRUE} to let the program automatically detect outliers in the dataset.
}
\examples{
\dontshow{
data("pursat")
data = pursat[pursat["id"] <= 80 & pursat["id"] > 70,]
output <- calculatePCE(data = data, detect.limit = 15, outlier.detect = TRUE)
}
\donttest{
data("pursat")
output <- calculatePCE(data = pursat, detect.limit = 15, outlier.detect = TRUE)
}
}
\references{
Flegg, J. A., Guerin, P. J., White, N. J., & Stepniewska, K. (2011). 
Standardizing the measurement of parasite clearance in falciparum malaria: the parasite clearance estimator. 
Malaria journal, 10(1), 339.
}
\author{
Colin B. Fogarty <cfogarty@mit.edu>, Saeed Sharifi-Malvajerdi <saeedsh@wharton.upenn.edu>, Feiyu Zhu <feiyuzhu@sas.upenn.edu>
}
