% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isibib2df.R
\name{isibib2df}
\alias{isibib2df}
\title{Convert an Clarivate Analitycs WoS Export file into a data frame}
\usage{
isibib2df(D)
}
\arguments{
\item{D}{is a character array containing data read from an WoS Export file (in bibtex format).}
}
\value{
a data frame with cases corresponding to articles and variables to Field Tag in the original SCOPUS file.
}
\description{
It converts an Clarivate Analitycs WoS Export file and create a data frame from it, with cases corresponding to articles and variables to Field Tag in the original file.
}
\examples{
# A ISI Export file can be read using \\code{\\link{readLines}} function:

# largechar <- readFiles('filename1.bib','filename2.bib2,...)

# filename.bib is a Clarivate Analytics WoS Export file in plain text format.

# largechar <- readFiles('http://www.bibliometrix.org/datasets/ranking.bib')

# ranking <- isibib2df(largechar)

}
\seealso{
\code{\link{isi2df}} for converting ISI Export file (in plain text format)

Other converting functions: \code{\link{convert2df}},
  \code{\link{isi2df}}, \code{\link{scopus2df}}
}
