% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdf_ftf.R
\docType{data}
\name{flex_d_lst}
\alias{flex_d_lst}
\title{A list of all flexible date types}
\format{
An object of class \code{list} of length 26.
}
\usage{
flex_d_lst
}
\value{
A list where each element corresponds to a classifier for a flexible
date type.
}
\description{
The \code{flex_d_lst} object is a list of widely supported flexible date types.
Flexible date types are classes of date formatting which can be translated
across locales. There are 26 flexible date types in
\code{flex_d_lst}.
}
\section{Examples}{


The \code{flex_d_lst} object can be incredibly useful when you need to get a
format for date formatting that works across all locales. You can avoid
typing errors by using this list and every flexible date type from this list
is guaranteed to work across all supported locales. In this example, we'll
use the \code{"yMMMEd"} flexible date type by accessing it from the \code{flex_d_lst}
object.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fdt(
  input = "2018-07-04 22:05",
  format = flex_d_lst$yMMMEd,
  locale = "en"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "Wed, Jul 4, 2018"
}\if{html}{\out{</div>}}

If we wanted this in a different locale, the locale-specific \code{format} pattern
behind the flexible date identifier would ensure consistency while moving to
that locale. Let's use the \code{fdt_locales_lst} object in the same spirit to
specify the French (Canada) locale.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fdt(
  input = "2018-07-04 22:05",
  format = flex_d_lst$yMMMEd,
  locale = fdt_locales_lst$fr_CA
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "mer. 4 juill. 2018"
}\if{html}{\out{</div>}}
}

\keyword{datasets}
