% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdm_qMap.R
\name{bdm.qMap}
\alias{bdm.qMap}
\title{ptSNE quantile-maps}
\usage{
bdm.qMap(bdm, layer = 1, data = NULL, labels = NULL, subset = NULL,
  levels = 16, cex = 0.3)
}
\arguments{
\item{bdm}{A \var{bdm} instance as generated by \code{bdm.init()}.}

\item{layer}{The number of a layer (1 by default).}

\item{data}{A \code{matrix/data.frame} to be mapped. By default, the input data \var{bdm$data} is mapped.}

\item{labels}{If available, labels can be included as a separate vector of length equal to \code{nrow(dSet.data)}. Label values are factorized as \code{as.numeric(as.factor(labels))}.}

\item{subset}{A numeric vector with the indexes of a subset of data. Data-points in the subset are heat-mapped and the rest are shown in light grey. By default all data-points are heat-mapped.}

\item{levels}{The number of levels of the heat-map (16 by default).}

\item{cex}{The size of the data-points (as in \code{par()}).}
}
\value{
None.
}
\description{
Shows the mapping of quantitative variables into the embedding space.
}
\examples{

bdm.example()
bdm.qMap(exMap)
# --- show only components (1, 2, 4, 8) of the GMM
bdm.qMap(exMap, subset = which(exMap$lbls \%in\% c(1, 4, 8, 16)))
}
