% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{bqr_auth}
\alias{bqr_auth}
\title{Authenticate this session}
\usage{
bqr_auth(json_file = NULL, token = NULL,
  email = Sys.getenv("GARGLE_EMAIL"))
}
\arguments{
\item{json_file}{Authentication json file you have downloaded from your Google Project}

\item{token}{A preexisting token to authenticate with}

\item{email}{A Google email to authenticate with

If you have set the environment variable \code{BQ_AUTH_FILE} to a valid file location,
  the function will look there for authentication details.
Otherwise it will trigger an authentication flow via Google login screen in your browser based on the email you provide.

If \code{BQ_AUTH_FILE} is specified, then authentication will be called upon loading the package
  via \code{library(bigQueryR)},
  meaning that calling this function yourself at the start of the session won't be necessary.

\code{BQ_AUTH_FILE} is a GCP service account JSON ending with file extension \code{.json}}
}
\value{
Invisibly, the token that has been saved to the session
}
\description{
Autheticate manually via email or service JSON file
}
\examples{

\dontrun{

# to use default package credentials (for testing)
library(bigQueryR)
bqr_auth("location_of_json_file.json")

# or via email
bqr_auth(email="me@work.com")

# to use your own Google Cloud Project credentials
# go to GCP console and download client credentials JSON 
# ideally set this in .Renviron file, not here but just for demonstration
Sys.setenv("GAR_CLIENT_JSON" = "location/of/file.json")
library(bigQueryR)
# should now be able to log in via your own GCP project
bqr_auth()

# reauthentication
# Once you have authenticated, set email to skip the interactive message
bqr_auth(email = "my@email.com")

# or leave unset to bring up menu on which email to auth with
bqr_auth()
# The bigQueryR package is requesting access to your Google account. 
# Select a pre-authorised account or enter '0' to obtain a new token.
# Press Esc/Ctrl + C to abort.
#1: my@email.com
#2: work@mybusiness.com
# you can set authentication for many emails, then switch between them e.g.
bqr_auth(email = "my@email.com")
bqr_list_projects() # lists what GCP projects you have access to
bqr_auth(email = "work@mybusiness.com") 
bqr_list_projects() # lists second set of projects



}
}
