% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{ari}
\alias{ari}
\title{Compute the adjusted rand index (ARI) between two clusterings}
\usage{
ari(z_star, z)
}
\arguments{
\item{z_star}{The true block membership}

\item{z}{The estimated block membership}
}
\value{
The adjusted rand index
}
\description{
This function computes the adjusted rand index (ARI) of the true and estimated block membership (its definition can be found here \url{https://en.wikipedia.org/wiki/Rand_index}).
The adjusted rand index is used as a measure of association between two group membership vectors.
The more similar the two partitions z_star and z are, the closer the ARI is to 1.
}
\examples{
data(toyNet)
set.seed(123)
ari(z_star = toyNet\%v\% "block",
z = sample(c(1:4),size = 200,replace = TRUE))
}
