% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{state_twitter}
\alias{state_twitter}
\title{Twitter (X) network of U.S. state legislators}
\format{
A \code{statnet}'s network class object. It has the following categorical attributes for each state legislator.
\describe{
\item{gender}{factor stating whether the legislator is 'female' or 'male'.}
\item{party}{party affiliation of the legislator, which is 'Democratic', 'Independent' or 'Republican'.}
\item{race}{race with the following levels: 'Asian or Pacific Islander', 'Black', 'Latino', 'MENA(Middle East and North Africa)','Multiracial', 'Native American', and 'White'.}
\item{state}{character of the state that the legislator represents.}
}
}
\usage{
data(state_twitter)
}
\description{
The network includes the Twitter (X) following interactions between U.S. state legislators.
The data was collection by Gopal et al. (2022) and Kim et al. (2022).
For this network, we only include the largest connected component of state legislators that were active on Twitter in the six months leading up to and including the insurrection at the United States Capitol on January 6, 2021.
All state senate and state representatives for states with a bicameral system are included and all state legislators for state (Nebraska) with a unicameral system are included.
}
\references{
Gopal, Kim, Nakka, Boehmke, Harden, Desmarais.
The National Network of U.S. State Legislators on Twitter.
Political Science Research & Methods, Forthcoming.

Kim, Nakka, Gopal, Desmarais,Mancinelli, Harden, Ko, and Boehmke (2022).
Attention to the COVID-19 pandemic on Twitter: Partisan differences among U.S. state legislators. Legislative Studies Quarterly 47, 1023–1041.
}
