% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/potential_radiation.r
\name{potential.radiation}
\alias{potential.radiation}
\title{Potential radiation}
\usage{
potential.radiation(doy, hour, latDeg, longDeg, timezone,
  useSolartime = TRUE)
}
\arguments{
\item{doy}{Integer vector with day of year (start at 1), same length as \code{hour} or length 1.}

\item{hour}{Numeric vector with daytime as decimal hour of local time zone}

\item{latDeg}{Latitude (decimal degrees)}

\item{longDeg}{Longitude (decimal degrees)}

\item{timezone}{Time zone (hours)}

\item{useSolartime}{by default corrects hour (given in local winter time)
for latitude to solar time (where noon is exactly at 12:00).
Set this to \code{FALSE} to directly use local winter time.}
}
\value{
vector of potential radiation (W m-2)
}
\description{
Compute potential radiation for given geolocation and day of year.
}
\examples{
hour <- seq(5, 18, by = 0.1)
potRadApparentLocal <- potential.radiation(
  160, hour, 39.94, -5.77, timezone = +1)
potRadTimezone <- potential.radiation(
  160, hour, 39.94, -5.77, timezone = +1, useSolartime = FALSE)
plot(potRadApparentLocal ~ hour, type = 'l'
  , ylab = 'potential radiation (W m-2)')
lines(potRadTimezone ~  hour, col = "blue")
abline(v = 12, col = "blue", lty = "dotted")
legend("bottomright", legend = c("solar time", "local winter time")
, col = c("black", "blue"), inset = 0.05, lty = 1)
}
