% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq.R
\name{seq.bignum_vctr}
\alias{seq.bignum_vctr}
\title{Sequences of bignum vectors}
\usage{
\method{seq}{bignum_vctr}(from, to = NULL, by = NULL, length.out = NULL, along.with = NULL, ...)
}
\arguments{
\item{from}{Start value of the sequence. Always included in the result.

A \code{\link{biginteger}} or \code{\link{bigfloat}} scalar.}

\item{to}{Stop value of the sequence. Only included in the result if \code{by}
divides the interval between \code{from} and \code{to} exactly.

\code{to} is cast to the type of \code{from}.}

\item{by}{Amount to increment the sequence by.

\code{by} is cast to the type of \code{from}.}

\item{length.out}{Length of the resulting sequence.}

\item{along.with}{Vector who's length determines the length of the resulting sequence.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A sequence with the type of \code{from}.
}
\description{
Generate a regular sequence of \code{\link{biginteger}} or \code{\link{bigfloat}} values.

When calling \code{seq()}, exactly two of the following must be specified:
\itemize{
\item \code{to}
\item \code{by}
\item Either \code{length.out} or \code{along.with}
}
}
\examples{
seq(biginteger(0), 10, by = 2)

seq(biginteger(0), 10, length.out = 3)

seq(biginteger(0), by = 3, length.out = 3)

seq(bigfloat(0), by = -0.05, length.out = 6)
}
