% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/job-upload.r
\name{insert_upload_job}
\alias{insert_upload_job}
\title{Upload data.}
\usage{
insert_upload_job(project, dataset, table, values, billing = project,
  create_disposition = "CREATE_IF_NEEDED",
  write_disposition = "WRITE_APPEND", ...)
}
\arguments{
\item{project}{The project name, a string}

\item{dataset}{The name of the dataset to create, a string}

\item{table}{name of table to insert values into}

\item{values}{data frame of data to upload}

\item{billing}{project ID to use for billing}

\item{create_disposition}{behavior for table creation if the destination
already exists. defaults to \code{"CREATE_IF_NEEDED"},
the only other supported value is \code{"CREATE_NEVER"}; see
\href{https://cloud.google.com/bigquery/docs/reference/v2/jobs#configuration.load.createDisposition}{the API documentation}
for more information}

\item{write_disposition}{behavior for writing data if the destination already
exists. defaults to \code{"WRITE_APPEND"}, other possible values are
\code{"WRITE_TRUNCATE"} and \code{"WRITE_EMPTY"}; see
\href{https://cloud.google.com/bigquery/docs/reference/v2/jobs#configuration.load.writeDisposition}{the API documentation}
for more information}

\item{...}{Additional arguments merged into the body of the
request. \code{snake_case} will automatically be converted into
\code{camelCase} so you can use consistent argument names.}
}
\description{
This sends all of the data inline in the HTTP request so is only suitable
for relatively small datasets.
}
\examples{
\dontrun{
list_datasets("193487687779")
list_tables("193487687779", "houston")
job <- insert_upload_job("193487687779", "houston", "mtcars", mtcars)
wait_for(job)
list_tables("193487687779", "houston")
delete_table("193487687779", "houston", "mtcars")
}
}
\seealso{
Google API documentation:
\url{https://developers.google.com/bigquery/loading-data-into-bigquery#loaddatapostrequest}

Other jobs: \code{\link{get_job}},
  \code{\link{insert_extract_job}},
  \code{\link{insert_query_job}}, \code{\link{wait_for}}
}
